	clear all
	close all
	clc
	L = 6;
	x = fir2(100,[0,0.1,0.2,0.9,1],[0,0,1,0,0]);             % Input signal signal 
	wT = linspace(0,pi,1000);
	X = freqz(x,1,wT);
	subplot(4,1,1); PLOT_ABS_Z(wT, abs(X), 'X')
	x_up = UP_SAMPLE(x,L);									% Up-sampling
	X_up = freqz(x_up,1,wT);								% Spectrum of the up-sampled signal
	subplot(4,1,2); PLOT_ABS_Z(wT, abs(X_up), 'X_u_p')
	for n = 1:L-1
		plot([1, 1]*n*pi/L,[0.15,0.85], 'linewidth',1); 													% Band edges
	end
	d = 0.1/L;
	hBP = REMEZ_FIR(120, [0,0.5-d,0.5+d,2/3-d,2/3+d,1]*pi, [0,0,1,1,0,0],[1 1 1], 'm'); 
	HBP = freqz(hBP,1,wT); 
	subplot(4,1,3); PLOT_MAG_Z_dB(wT, HBP, pi, 60, 'H_B_P')
	subplot(4,1,4); PLOT_ABS_Z(wT, abs(HBP.*X_up), 'Y')
	xlabel('{\it\omegaT} [rad]');
